/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.theoneprobe.overrides;

import dev.compactmods.machines.machine.CompactMachineBlock;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import java.util.Optional;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CompactMachineNameOverride
implements IBlockDisplayOverride {
    public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData hitData) {
        BlockEntity blockEntity;
        if (blockState.m_60734_() instanceof CompactMachineBlock && (blockEntity = level.m_7702_(hitData.getPos())) instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity mach = (CompactMachineBlockEntity)blockEntity;
            Optional<ChunkPos> cr = mach.getConnectedRoom();
            if (cr.isEmpty()) {
                return false;
            }
            cr.ifPresent(room -> {
                ItemStack pickBlock = hitData.getPickBlock();
                if (!pickBlock.m_41619_()) {
                    BaseComponent roomName;
                    IProbeConfig config = Config.getRealConfig();
                    String modName = Tools.getModName((IForgeRegistryEntry)blockState.m_60734_());
                    try {
                        roomName = Rooms.getRoomName(level.m_142572_(), room).map(n -> new TextComponent(n)).orElse((BaseComponent)pickBlock.m_41786_());
                    }
                    catch (NonexistentRoomException e) {
                        roomName = (BaseComponent)pickBlock.m_41786_();
                    }
                    if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)config.getShowModName())) {
                        probeInfo.horizontal().item(pickBlock).vertical().mcText((Component)roomName).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
                    } else {
                        probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).mcText((Component)roomName);
                    }
                }
            });
            return true;
        }
        return false;
    }
}

